#include "stdafx.h"
#include "common.h"
#include "tree.h"
#include "error.h"
//#include "process.h"
#include <string.h>
#include <stdlib.h>
#include "code.h"
#include "asmutils.h"

//****************************************************************************************************************
//Funkce prida instrukci do spojoveho seznamu instrukci
//****************************************************************************************************************
void CCode::AddInstruction(CInstruction* instruction)
{
	if (!m_CurrCodeStart)			//pokud ukazatekl na zacetk kodu je neplatny
	{								//znamena to ze do seznamu nebyla jest pridana ani prvni instrukce
		m_CurrCodeStart = m_CurrCode = instruction;		//nastavime proto zacatek seznamu instrukci na nove pridavanou instrukci
	}
	else
	{
		m_CurrCode->next = instruction;		//ukazatel na dalsi instrukci u soucane instrukce nastavime na nove pridavanou instrukci
		m_CurrCode = m_CurrCode->next;		//ukazatel na soucasnou instrukci nastavime na nove pridanou instrukci
	}
}
//****************************************************************************************************************
//Prida do seznamu instrukci nop
//****************************************************************************************************************
void CCode::instruct_nop()
{
	CInstruction* pInstruction = new CInstruction;
	pInstruction->nop(NULL);
	AddInstruction(pInstruction);
}
//****************************************************************************************************************
//Prida do seznamu instrukci mul
//****************************************************************************************************************
void CCode::instruct_mul()
{
	CInstruction* pInstruction = new CInstruction;
	pInstruction->mul(NULL);
	AddInstruction(pInstruction);
}
//****************************************************************************************************************
//Prida do seznamu instrukci neg
//****************************************************************************************************************
void CCode::instruct_neg()
{
	CInstruction* pInstruction = new CInstruction;
	pInstruction->neg(NULL);
	AddInstruction(pInstruction);
}
//****************************************************************************************************************
//Prida do seznamu instrukci mod
//****************************************************************************************************************
void CCode::instruct_mod()
{
	CInstruction* pInstruction = new CInstruction;
	pInstruction->mod(NULL);
	AddInstruction(pInstruction);
}
//****************************************************************************************************************
//Prida do seznamu instrukci sub
//****************************************************************************************************************
void CCode::instruct_sub()
{
	CInstruction* pInstruction = new CInstruction;
	pInstruction->sub(NULL);
	AddInstruction(pInstruction);
}
//****************************************************************************************************************
//Prida do seznamu instrukci div
//****************************************************************************************************************
void CCode::instruct_div()
{
	CInstruction* pInstruction = new CInstruction;
	pInstruction->div(NULL);
	AddInstruction(pInstruction);
}
//****************************************************************************************************************
//Prida do seznamu instrukci add
//****************************************************************************************************************
void CCode::instruct_add()
{
	CInstruction* pInstruction = new CInstruction;
	pInstruction->add(NULL);
	AddInstruction(pInstruction);
}
//****************************************************************************************************************
//Prida do seznamu navesti
//****************************************************************************************************************
void CCode::instruct_label(char* name, int label)
{
	//tady se vlastne postupne zaplnuje seznam navesti pro dany kod dane funkce
	m_CurrLabels[label].name = name;				
	CInstruction* pInstruction = new CInstruction;	//vytvor novou instrukci
	pInstruction->label(label,NULL);		//instrukce je  typu label
	AddInstruction(pInstruction);
	m_CurrLabels[label].position = m_CurrCode;
}
//****************************************************************************************************************
//Prida do seznamu instrukci goto
//****************************************************************************************************************
void CCode::instruct_lgoto(int label)
{
	CInstruction* pInstruction = new CInstruction;
	pInstruction->lgoto(label,NULL);
	AddInstruction(pInstruction);
}
//****************************************************************************************************************
//Prida do seznamu instrukci ifeq
//****************************************************************************************************************
void CCode::instruct_ifeq(int label)
{
	CInstruction* pInstruction = new CInstruction;
	pInstruction->ifeq(label,NULL);
	AddInstruction(pInstruction);
}
//****************************************************************************************************************
//Prida do seznamu instrukci ifne
//****************************************************************************************************************
void CCode::instruct_ifne(int label)
{
	CInstruction* pInstruction = new CInstruction;
	pInstruction->ifne(label,NULL);
	AddInstruction(pInstruction);
}
//****************************************************************************************************************
//Prida do seznamu instrukci if_cmpeq
//****************************************************************************************************************
void CCode::instruct_if_cmpeq(int label)
{
	CInstruction* pInstruction = new CInstruction;
	pInstruction->if_cmpeq(label,NULL);
	AddInstruction(pInstruction);
}
//****************************************************************************************************************
//Prida do seznamu instrukci if_cmpgt
//****************************************************************************************************************
void CCode::instruct_if_cmpgt(int label)
{
	CInstruction* pInstruction = new CInstruction;
	pInstruction->if_cmpgt(label,NULL);
	AddInstruction(pInstruction);
}
//****************************************************************************************************************
//Prida do seznamu instrukci if_cmplt
//****************************************************************************************************************
void CCode::instruct_if_cmplt(int label)
{
	CInstruction* pInstruction = new CInstruction;
	pInstruction->if_cmplt(label,NULL);
	AddInstruction(pInstruction);
}
//****************************************************************************************************************
//Prida do seznamu instrukci if_cmple
//****************************************************************************************************************
void CCode::instruct_if_cmple(int label)
{
	CInstruction* pInstruction = new CInstruction;
	pInstruction->if_cmple(label,NULL);
	AddInstruction(pInstruction);
}
//****************************************************************************************************************
//Prida do seznamu instrukci if_cmpge
//****************************************************************************************************************
void CCode::instruct_if_cmpge(int label)
{
	CInstruction* pInstruction = new CInstruction;
	pInstruction->if_cmpge(label,NULL);
	AddInstruction(pInstruction);
}
//****************************************************************************************************************
//Prida do seznamu instrukci if_cmpne
//****************************************************************************************************************
void CCode::instruct_if_cmpne(int label)
{
	CInstruction* pInstruction = new CInstruction;
	pInstruction->if_cmpne(label,NULL);
	AddInstruction(pInstruction);
}
//****************************************************************************************************************
//Prida do seznamu instrukci nreturn
//****************************************************************************************************************
void CCode::instruct_nreturn()
{
	CInstruction* pInstruction = new CInstruction;
	pInstruction->nreturn(NULL);
	AddInstruction(pInstruction);
}
//****************************************************************************************************************
//Prida do seznamu instrukci vreturn
//****************************************************************************************************************
void CCode::instruct_vreturn()
{
	CInstruction* pInstruction = new CInstruction;
	pInstruction->vreturn(NULL);
	AddInstruction(pInstruction);
}
//****************************************************************************************************************
//Prida do seznamu instrukci load
//****************************************************************************************************************
void CCode::instruct_load(int arg)
{
	CInstruction* pInstruction = new CInstruction;
	pInstruction->load(arg,NULL);
	AddInstruction(pInstruction);
}
//****************************************************************************************************************
//Prida do seznamu instrukci store
//****************************************************************************************************************
void CCode::instruct_store(int arg)
{
	CInstruction* pInstruction = new CInstruction;
	pInstruction->store(arg,NULL);
	AddInstruction(pInstruction);
}
//****************************************************************************************************************
//Prida do seznamu instrukci dup
//****************************************************************************************************************
void CCode::instruct_dup()
{
	CInstruction* pInstruction = new CInstruction;
	pInstruction->dup(NULL);
	AddInstruction(pInstruction);
}
//****************************************************************************************************************
//Prida do seznamu instrukci pop
//****************************************************************************************************************
void CCode::instruct_pop()
{
	CInstruction* pInstruction = new CInstruction;
	pInstruction->pop(NULL);
	AddInstruction(pInstruction);
}
//****************************************************************************************************************
//Prida do seznamu instrukci ldc_int
//****************************************************************************************************************
void CCode::instruct_ldc_int(int arg)
{
	CInstruction* pInstruction = new CInstruction;
	pInstruction->ldc_int(arg,NULL);
	AddInstruction(pInstruction);
}
//****************************************************************************************************************
//Prida do seznamu instrukci ldc_string
//****************************************************************************************************************
void CCode::instruct_ldc_string(char* arg)
{
	CInstruction* pInstruction = new CInstruction;
	pInstruction->ldc_string(arg,NULL);
	AddInstruction(pInstruction);
}
//****************************************************************************************************************
//Prida do seznamu instrukci ldc_double
//****************************************************************************************************************
void CCode::instruct_ldc_double(double arg)
{
	CInstruction* pInstruction = new CInstruction;
	pInstruction->ldc_double(arg,NULL);
	AddInstruction(pInstruction);
}
//****************************************************************************************************************
//Prida do seznamu instrukci ldc_lcall
//****************************************************************************************************************
void CCode::instruct_lcall(FUNCTION* arg)
{
	CInstruction* pInstruction = new CInstruction;
	pInstruction->lcall(arg,NULL);
	AddInstruction(pInstruction);
}
//****************************************************************************************************************
//Prida do seznamu instrukci ldc_ecall
//****************************************************************************************************************
void CCode::instruct_ecall(FUNCTION* arg,int args)
{
	CInstruction* pInstruction = new CInstruction;
	pInstruction->ecall(arg,args,NULL);
	AddInstruction(pInstruction);
}
//****************************************************************************************************************
//Prida do seznamu instrukci shl
//****************************************************************************************************************
void CCode::instruct_shl()
{
	CInstruction* pInstruction = new CInstruction;
	pInstruction->shl(NULL);
	AddInstruction(pInstruction);
}
//****************************************************************************************************************
//Prida do seznamu instrukci shr
//****************************************************************************************************************
void CCode::instruct_shr()
{
	CInstruction* pInstruction = new CInstruction;
	pInstruction->shr(NULL);
	AddInstruction(pInstruction);
}
//****************************************************************************************************************
//Prida do seznamu instrukci dec
//****************************************************************************************************************
void CCode::instruct_dec()
{
	CInstruction* pInstruction = new CInstruction;
	pInstruction->dec(NULL);
	AddInstruction(pInstruction);
}
//****************************************************************************************************************
//Prida do seznamu instrukci inc
//****************************************************************************************************************
void CCode::instruct_inc()
{
	CInstruction* pInstruction = new CInstruction;
	pInstruction->inc(NULL);
	AddInstruction(pInstruction);
}
//****************************************************************************************************************
//Prida do seznamu instrukci and
//****************************************************************************************************************
void CCode::instruct_and()
{
	CInstruction* pInstruction = new CInstruction;
	pInstruction->and(NULL);
	AddInstruction(pInstruction);
}
//****************************************************************************************************************
//Prida do seznamu instrukci or
//****************************************************************************************************************
void CCode::instruct_or()
{
	CInstruction* pInstruction = new CInstruction;
	pInstruction->or(NULL);
	AddInstruction(pInstruction);
}
//****************************************************************************************************************
//Prida do seznamu instrukci store podle lvalue
//****************************************************************************************************************
void CCode::instruct_store_lvalue(LVALUE* lvalue)
{
	if (lvalue->symbol->kind != declarationT)
	{
		theLog.ReportError(lvalue->line_number,"Lvalue '%s' in expression is not a variable!\n",lvalue->symbol->name);
	}
	else
	{
		switch (lvalue->symbol->val.declarationS->kind)
		{
		case simplevarT:
			instruct_store(lvalue->symbol->val.declarationS->val.simplevarD.offset);
			break;
		case variableT:
			instruct_store(lvalue->symbol->val.declarationS->val.variableD.offset);
			break;
		case formalT:
			instruct_store(lvalue->symbol->val.declarationS->val.formalD.offset);
			break;
		}
	}
}

//****************************************************************************************************************
/*rekursivni pruchod stromem*/
//****************************************************************************************************************
void CCode::Process(SCRIPT* theScript)
{
	if (theScript->toplevels)
		processTOPLEVEL(theScript->toplevels);
}
//****************************************************************************************************************
//Pruchod vetvemi stromu
//****************************************************************************************************************
void CCode::processTOPLEVEL(TOPLEVEL* toplevel)
{
	processFUNCTION(toplevel->function);

	if (toplevel->next != NULL)
		processTOPLEVEL(toplevel->next);
}
//****************************************************************************************************************
//Pruchod funkcemi
//****************************************************************************************************************
void CCode::processFUNCTION(FUNCTION* function)
{
	if (function->kind == localT)		//sestavovat kod ma smysl jen pro lokalni funkci, u externi nezname telo
	{
		m_CurrCodeStart = NULL;			//seznam instrukci je prazdny
		function->labels = new LABEL[function->labelCount];	//vytvor pole pro navesti
		m_CurrLabels = function->labels;	//ukazatel na aktualni pole popisku nastav na nove vytvorene pole

		if (function->statements != NULL)
			processSTATEMENT(function->statements);		//zpracuj telo funkce

		//uloz ukazatel na seznam instrukci
		function->opcodes = m_CurrCodeStart;
	}
}
//****************************************************************************************************************
//Pruchod deklaracemi
//****************************************************************************************************************
void CCode::processDECLARATION(DECLARATION* declaration)
{
	switch (declaration->kind)
	{
	case formalT:
		break;
	case variableT:
		if (declaration->val.variableD.initialization != NULL)
		{
			processEXPRESSION(declaration->val.variableD.initialization);	//zpracuj inicializaci

			instruct_store(declaration->val.variableD.offset);	//inicializace uz byla zpracovana, jejim vysledkem
																//bude nejaka hodnota na vrcholu zasobniku. Deklarovat promennou
																//uz znamena jen tuto hodnotu presunout do vyhrazeneho mista
		}
		break;
	case simplevarT:
		if (declaration->val.simplevarD.initialization != NULL)
		{
			processEXPRESSION(declaration->val.simplevarD.initialization);		// blede modrym pripad variableT:

			instruct_store(declaration->val.simplevarD.offset);
		}
		break;
	}

	if (declaration->next != NULL)
		processDECLARATION(declaration->next);
}
//****************************************************************************************************************
//Pruchod inicializaci for cyklu
//****************************************************************************************************************
void CCode::processFORINIT(FORINIT* forinit)
{
	switch (forinit->kind)
	{
	case declarationforinitT:
		processDECLARATION(forinit->val.declarationF);
		break;
	case expressionforinitT:
		processEXPRESSION(forinit->val.expressionF);
		break;
	}

	if (forinit->next != NULL)
		processFORINIT(forinit->next);
}
//****************************************************************************************************************
//Pruchod prikazy
//****************************************************************************************************************
void CCode::processSTATEMENT(STATEMENT* statement)
{
	switch (statement->kind)
	{
	case skipT:
		break;
	case expT:
		//zpracuj vyraz
		processEXPRESSION(statement->val.expression);
		//podminka souvisi s pravidlem ze kazda operace musi zasobnik zanechat ve stavu v jakem byl pred
		//spustenim operace. Tz. ze pokud operace neco uklada na zasobnik, musi to pred skoncenim vsechno vyjmout, aby
		//by ukazatel zasobniku byl stejny jako pred operaci
		if (statement->val.expression->kind == callT)
			if (statement->val.expression->val.callE.symbol->val.functionS->returns_value == false)
				instruct_nop();
			else
				instruct_pop();
		else
			instruct_pop();

		break;
	case declstmT:
		processDECLARATION(statement->val.declaration);
		break;
	case returnT:
		//pokud prikaz vraci return nevraci hodnotu, vloz instrukci nreturn, jinak
		//se vlozi vreturn. Jde o to ze kazda se chova trocku jinak
		if (statement->val.returnS.expression == NULL)
			instruct_nreturn();
		else
		{
			processEXPRESSION(statement->val.returnS.expression);
			instruct_vreturn();
		}
		break;
	case ifT:
		//vygeneruj kod pro vyraz predstavujici podminku
		processEXPRESSION(statement->val.ifS.condition);
		//vloz podmineny skok, ktery skoci pokud podminka neni splnena za telo podminky
		instruct_ifeq(statement->val.ifS.stoplabel);
		//vloz telo podminky
		processSTATEMENT(statement->val.ifS.body);
		//vloz navesti znacici konec tela podminky
		instruct_label("stop",statement->val.ifS.stoplabel);
		break;
	case ifelseT:
		//vygeneuj kod pro vyraz predstavujici podminku
		processEXPRESSION(statement->val.ifelseS.condition);
		instruct_ifeq(statement->val.ifelseS.elselabel);
		processSTATEMENT(statement->val.ifelseS.ifbody);
		instruct_lgoto(statement->val.ifelseS.stoplabel);
		instruct_label("else",statement->val.ifelseS.elselabel);
		processSTATEMENT(statement->val.ifelseS.elsebody);
		instruct_label("stop",statement->val.ifelseS.stoplabel);
		break;
	case whileT:
		instruct_label("start",statement->val.whileS.startlabel);
		processEXPRESSION(statement->val.whileS.condition);
		instruct_ifeq(statement->val.whileS.stoplabel);
		processSTATEMENT(statement->val.whileS.body);
		instruct_lgoto(statement->val.whileS.startlabel);
		instruct_label("stop",statement->val.whileS.stoplabel);
		break;
	case forT:
		//nejdriv vygeneruj kod pro inicializaci skriptu
		processFORINIT(statement->val.forS.inits);
		//vloz navesti oznacujici zacatek cyklu
		instruct_label("start",statement->val.forS.startlabel);
		//vygenruj kod pro podminku
		processEXPRESSION(statement->val.forS.condition);
		//vloz skok na konec cyklu pokud podminka neplati
		instruct_ifeq(statement->val.forS.stoplabel);
		//vygeneruj kod pro telo cyklu
		processSTATEMENT(statement->val.forS.body);
		//vygeneruj kod pro aktualizaci cyklu
		processEXPRESSION(statement->val.forS.updates);
		//podminka souvisi s pravidlem ze kazda operace musi zasobnik zanechat ve stavu v jakem byl pred
		//spustenim operace. Tz. ze pokud operace neco uklada na zasobnik, musi to pred skoncenim vsechno vyjmout, aby
		//by ukazatel zasobniku byl stejny jako pred operaci
		if (statement->val.forS.updates->kind == callT) 
			if (statement->val.forS.updates->val.callE.symbol->val.functionS->returns_value == false)
				instruct_nop();
			else
				instruct_pop();
		else
			instruct_pop();		
		//vloz skok na zactek cyklu
		instruct_lgoto(statement->val.forS.startlabel);
		//vloz navesti oznacujici konec cyklu
		instruct_label("stop",statement->val.forS.stoplabel);
		break;
	case sequenceT:
		processSTATEMENT(statement->val.sequenceS.firts);
		processSTATEMENT(statement->val.sequenceS.second);
		break;
	case scopeT:
		processSTATEMENT(statement->val.scopeS.statement);
		break;
	}
}
//****************************************************************************************************************
//Pruchod vyrazy
//****************************************************************************************************************
void CCode::processEXPRESSION(EXPRESSION*	expression)
{
	if (expression == NULL)
		return;

	switch (expression->kind)
	{
	case intconstT:
		instruct_ldc_int(expression->val.intconstE);
		break;
	case stringconstT:
		instruct_ldc_string(expression->val.stringconstE);
		break;
	case doubleconstT:
		instruct_ldc_double(expression->val.doubleconstE);
		break;
	case uminusT:
		processEXPRESSION(expression->val.uminusE);
		instruct_neg();
		break;
	case notT:
		processEXPRESSION(expression->val.notE.expression);
		instruct_ifeq(expression->val.notE.truelabel);
		instruct_ldc_int(0);
		instruct_lgoto(expression->val.notE.stoplabel);
		instruct_label("true",expression->val.notE.truelabel);
		instruct_ldc_int(1);
		instruct_label("stop",expression->val.notE.stoplabel);
		break;
	case lvalueT:
		processLVALUE(expression->val.lvalue);
		break;
	case assignmentT:
		//zpracuj vraz na prav stran
		processEXPRESSION(expression->val.assignmentE.right);
		//vysledek okopiruj do zasobniku
		instruct_dup();
		//uloz to do promenne		
		instruct_store_lvalue(expression->val.assignmentE.left);
		break;
	case plusassignT:
		//nacteni hodnoty co vlevo
		processLVALUE(expression->val.plusassignE.left);
		//vyhodnoceni vyrazu vpravo
		processEXPRESSION(expression->val.plusassignE.right);
		//secteni hodnot
		instruct_add();
		instruct_dup();
		//ulozeni do hodnoty vlevo
		instruct_store_lvalue(expression->val.plusassignE.left);
		break;
	case minusassignT:
		processLVALUE(expression->val.minusassignE.left);
		processEXPRESSION(expression->val.minusassignE.right);
		instruct_sub();
		instruct_dup();
		instruct_store_lvalue(expression->val.minusassignE.left);
		break;
	case mulassignT:
		processLVALUE(expression->val.mulassignE.left);
		processEXPRESSION(expression->val.mulassignE.right);
		instruct_mul();
		instruct_dup();
		instruct_store_lvalue(expression->val.mulassignE.left);
		break;
	case divassignT:
		processLVALUE(expression->val.divassignE.left);
		processEXPRESSION(expression->val.divassignE.right);
		instruct_div();
		instruct_dup();
		instruct_store_lvalue(expression->val.divassignE.left);
		break;
	case modassignT:
		processLVALUE(expression->val.modassignE.left);
		processEXPRESSION(expression->val.modassignE.right);
		instruct_mod();
		instruct_dup();
		instruct_store_lvalue(expression->val.modassignE.left);
		break;
	case shlassignT:
		processLVALUE(expression->val.shlassignE.left);
		processEXPRESSION(expression->val.shlassignE.right);
		instruct_shl();
		instruct_dup();
		instruct_store_lvalue(expression->val.shlassignE.left);
		break;
	case shrassignT:
		processLVALUE(expression->val.shrassignE.left);
		processEXPRESSION(expression->val.shrassignE.right);
		instruct_shr();
		instruct_dup();
		instruct_store_lvalue(expression->val.shrassignE.left);
		break;
	case equalsT:
		processEXPRESSION(expression->val.equalsE.left);
		processEXPRESSION(expression->val.equalsE.right);

		instruct_if_cmpeq(expression->val.equalsE.truelabel);

		instruct_ldc_int(0);
		instruct_lgoto(expression->val.equalsE.stoplabel);
		instruct_label("true",expression->val.equalsE.truelabel);
		instruct_ldc_int(1);
		instruct_label("stop",expression->val.equalsE.stoplabel);
		break;
	case nequalsT:
		processEXPRESSION(expression->val.nequalsE.left);
		processEXPRESSION(expression->val.nequalsE.right);

		instruct_if_cmpne(expression->val.nequalsE.truelabel);

		instruct_ldc_int(0);
		instruct_lgoto(expression->val.nequalsE.stoplabel);
		instruct_label("true",expression->val.nequalsE.truelabel);
		instruct_ldc_int(1);
		instruct_label("stop",expression->val.nequalsE.stoplabel);
		break;
	case lessT:
		//vygeneruj kod pro levou stranu podminky
		processEXPRESSION(expression->val.lessE.left);
		//vygeneruj kod pro pravou stranu podminky
		processEXPRESSION(expression->val.lessE.right);
		//vloz podmineny skok ktery skoci pokud leva starna je mensi nez prava
		instruct_if_cmplt(expression->val.lessE.truelabel);
		//podmineny skok neskocil, vloz na zasobnik nulu jako indikaci toho ze podminka nebyly splnena
		instruct_ldc_int(0);
		//vloz skok na misto kde si dalsi kod overi vysledek
		instruct_lgoto(expression->val.lessE.stoplabel);
		//vloz navesti, sem se skoci pokud je podminka splnena
		instruct_label("true",expression->val.lessE.truelabel);
		//vloz na zasobnik 1, indikace splenene podminky
		instruct_ldc_int(1);
		//navesti oznacujici misto kde bude vlozen kod ktery rozhodne co delat podle
		//vysledku porovnani
		instruct_label("stop",expression->val.lessE.stoplabel);
		break;
	case greaterT:
		processEXPRESSION(expression->val.greaterE.left);
		processEXPRESSION(expression->val.greaterE.right);
		instruct_if_cmpgt(expression->val.greaterE.truelabel);
		instruct_ldc_int(0);
		instruct_lgoto(expression->val.greaterE.stoplabel);
		instruct_label("true",expression->val.greaterE.truelabel);
		instruct_ldc_int(1);
		instruct_label("stop",expression->val.greaterE.stoplabel);
		break;
	case lequalsT:
        processEXPRESSION(expression->val.lequalsE.left);
		processEXPRESSION(expression->val.lequalsE.right);
		instruct_if_cmple(expression->val.lequalsE.truelabel);
		instruct_ldc_int(0);
		instruct_lgoto(expression->val.lequalsE.stoplabel);
		instruct_label("true",expression->val.lequalsE.truelabel);
		instruct_ldc_int(1);
		instruct_label("stop",expression->val.lequalsE.stoplabel);
		break;
	case gequalsT:
        processEXPRESSION(expression->val.gequalsE.left);
		processEXPRESSION(expression->val.gequalsE.right);
		instruct_if_cmple(expression->val.gequalsE.truelabel);
		instruct_ldc_int(0);
		instruct_lgoto(expression->val.gequalsE.stoplabel);
		instruct_label("true",expression->val.gequalsE.truelabel);
		instruct_ldc_int(1);
		instruct_label("stop",expression->val.gequalsE.stoplabel);
		break;
	case plusT:
		//vygeneruj kod pro levou stranu
		processEXPRESSION(expression->val.plusE.left);
		//vygeneruj kod pro pravou stranu
		processEXPRESSION(expression->val.plusE.right);
		//proved soucet
		instruct_add();
		break;
	case minusT:
		processEXPRESSION(expression->val.minusE.left);
		processEXPRESSION(expression->val.minusE.right);
		instruct_sub();
		break;
	case mulT:
		processEXPRESSION(expression->val.mulE.left);
		processEXPRESSION(expression->val.mulE.right);
		instruct_mul();
		break;
	case divT:
		processEXPRESSION(expression->val.divE.left);
		processEXPRESSION(expression->val.divE.right);
		instruct_div();
		break;
	case modT:
		processEXPRESSION(expression->val.modE.left);
		processEXPRESSION(expression->val.modE.right);
		instruct_mod();
		break;
	case shlT:
		processEXPRESSION(expression->val.shlE.left);
		processEXPRESSION(expression->val.shlE.right);
		instruct_shl();
		break;
	case shrT:
		processEXPRESSION(expression->val.shrE.left);
		processEXPRESSION(expression->val.shrE.right);
		instruct_shr();
		break;
	case prefincT:
		processLVALUE(expression->val.incE);
		instruct_inc();
		instruct_dup();
		instruct_store_lvalue(expression->val.incE);
		break;
	case prefdecT:
		processLVALUE(expression->val.decE);		//nacti promennou ktera se ma dekrementovat
		instruct_dec();								//dekrementuj ji
		instruct_dup();								//duplikuj promennou na yasobniku este jednou
		instruct_store_lvalue(expression->val.decE);	//uloz vrchol zasobniku ktery predstavuje dekrementovanou promennou zpet do promenne, jedna kopie na zasobniku este bude
		break;
	case postincT:
		processLVALUE(expression->val.incE);	//nacti promennou
		instruct_dup();							//okopiruj ji na vrchol zasobniku
		instruct_inc();							//inkrementuj promennou na vrcholu zasobniku
		instruct_store_lvalue(expression->val.incE);	//uloz vrchol zasobniku, tj inkrementovanou promennou. vrchol zasobniku se tak snizi o jedna a bude tam puvodni hodnota promenne neinkrementovana
		break;
	case bitorT:
		processEXPRESSION(expression->val.bitorE.left);
		processEXPRESSION(expression->val.bitorE.right);
		instruct_or();
		break;
	case bitandT:
		processEXPRESSION(expression->val.bitandE.left);
		processEXPRESSION(expression->val.bitandE.right);
		instruct_and();
		break;
	case postdecT:
		processLVALUE(expression->val.decE);
		instruct_dup();
		instruct_dec();
		instruct_store_lvalue(expression->val.decE);
		break;
	case andT:
		processEXPRESSION(expression->val.andE.left);
		instruct_dup();
		instruct_ifeq(expression->val.andE.falselabel);
		instruct_pop();
		processEXPRESSION(expression->val.andE.right);
		instruct_label("false",expression->val.andE.falselabel);
		break;
	case orT:
		processEXPRESSION(expression->val.orE.left);
		instruct_dup();
		instruct_ifne(expression->val.orE.truelabel);
		instruct_pop();
		processEXPRESSION(expression->val.orE.right);
		instruct_label("true",expression->val.orE.truelabel);
		break;
	case callT:
		if (expression->val.callE.arguments != NULL)
			processEXPRESSION(expression->val.callE.arguments);

		switch (expression->val.callE.symbol->val.functionS->kind)
		{
		case localT:
			instruct_lcall(expression->val.callE.symbol->val.functionS);
			break;
		case externT:
			instruct_ecall(expression->val.callE.symbol->val.functionS,countParameters(expression->val.callE.arguments));
			break;
		}
		
		break;
	}

	if (expression->next)
		processEXPRESSION(expression->next);
}
//****************************************************************************************************************
//pruchod lvalue
//****************************************************************************************************************
void CCode::processLVALUE(LVALUE* lvalue)
{
	switch (lvalue->kind)
	{
	case identifierT:
		switch (lvalue->symbol->val.declarationS->kind)
		{
		case formalT:
			instruct_load(lvalue->symbol->val.declarationS->val.formalD.offset);
			break;
		case variableT:
			instruct_load(lvalue->symbol->val.declarationS->val.variableD.offset);
			break;
		case simplevarT:
			instruct_load(lvalue->symbol->val.declarationS->val.simplevarD.offset);
			break;
		}
	}
}